#ifndef DESTILO_H
    #define DESTILO_H

    #include "DString.h"
    #include <vector>

    namespace DWL {
        // Macro que crea funciones para obtener y modificar un estilo en concreto
        #define DWL_DEFINIR_ESTILO(NOMBRE, POSICION)                                                                                                                \
            const BOOL  NOMBRE(void)            { return ((_Estilos & _DatosEstilos[POSICION].Valor) == _DatosEstilos[POSICION].Valor); };                          \
            void        NOMBRE(const BOOL nB)   { if (nB == TRUE) _Estilos |= _DatosEstilos[POSICION].Valor; else (_Estilos &=(~_DatosEstilos[POSICION].Valor)); };

        
        // Clase que contiene el nombre de una definicin y su valor
        class DEstilo {
          public :
                                DEstilo(const TCHAR *nDefinicion = NULL, const DWORD nValor = 0) : _Definicion(nDefinicion), Valor(nValor) {
                                }


            const TCHAR        *Definicion(void) {
                                    return _Definicion();
                                };

            DWORD               Valor;

          protected :

            DString            _Definicion;

            friend class DBaseWnd_Estilos;
            friend class DBaseWnd_EstilosEx;
            friend class DListView_Estilos;
            friend class DListView_EstilosEx;
        };

        class DEstilos {
          public :
                                    DEstilos(DWORD nEstilos) : _Estilos(nEstilos)           { };
            inline DWORD            operator() (void)                                       { return _Estilos; };
            inline const UINT       TotalEstilos(void)                                      { return static_cast<UINT>(_DatosEstilos.size()); };
            inline const bool       ObtenerEstiloPos(const UINT Pos)                        { return ((_Estilos & _DatosEstilos[Pos].Valor) == _DatosEstilos[Pos].Valor); };
            inline void             AsignarEstiloPos(const UINT Pos, const BOOL nActivar)   { if (nActivar == TRUE) _Estilos |= _DatosEstilos[Pos].Valor; else (_Estilos &=(~_DatosEstilos[Pos].Valor));};
            inline DEstilo         *Estilo(const UINT Pos)                                  { return &_DatosEstilos[Pos]; };
            inline DWORD            Estilos(void)                                           { return _Estilos; };
          protected :
            std::vector<DEstilo>   _DatosEstilos;
            DWORD                  _Estilos;

        };
    };

#endif